package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VimpresionDoc;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VimpresionDocDaoImpl generated by UDA, 05-sep-2017 8:53:43.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VimpresionDocDaoImpl implements VimpresionDocDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VimpresionDoc> rwMap = new RowMapper<VimpresionDoc>() {
		public VimpresionDoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VimpresionDoc(resultSet.getString("TIPO"),
					resultSet.getString("TER"), resultSet.getString("ANO"),
					resultSet.getInt("NUM"), resultSet.getLong("IDTRAM"),
					resultSet.getLong("TIPOTRAM"),
					resultSet.getString("PROCEDURE"),
					resultSet.getDate("FECPRE"), resultSet.getInt("CANALNOTIF"),
					resultSet.getString("OID"), resultSet.getString("NOMDOC"));
		}
	};

	private RowMapper<VimpresionDoc> rwMapPK = new RowMapper<VimpresionDoc>() {
		public VimpresionDoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VimpresionDoc(resultSet.getString("TIPO"),
					resultSet.getString("TER"), resultSet.getString("ANO"),
					resultSet.getInt("NUM"), resultSet.getLong("IDTRAM"),
					resultSet.getLong("TIPOTRAM"),
					resultSet.getString("PROCEDURE"),
					resultSet.getDate("FECPRE"), resultSet.getInt("CANALNOTIF"),
					resultSet.getString("OID"), resultSet.getString("NOMDOC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc VimpresionDoc
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @return the vimpresion doc
	 */
	public VimpresionDoc add(VimpresionDoc vimpresiondoc) {
		String query = "INSERT INTO VIMPRESION_DOC (TIPO, TER, ANO, NUM, IDTRAM, TIPOTRAM, PROCEDURE, FECPRE) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vimpresiondoc.getTipo(),
				vimpresiondoc.getTer(), vimpresiondoc.getAnio(),
				vimpresiondoc.getNum(), vimpresiondoc.getIdtram(),
				vimpresiondoc.getTipotram(), vimpresiondoc.getProcedure(),
				vimpresiondoc.getFecpre());
		return vimpresiondoc;
	}

	/**
	 * Updates a single row in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc VimpresionDoc
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @return the vimpresion doc
	 */
	public VimpresionDoc update(VimpresionDoc vimpresiondoc) {
		String query = "UPDATE VIMPRESION_DOC SET  WHERE TIPO=? AND TER=? AND ANO=? AND NUM=? AND IDTRAM=? AND TIPOTRAM=? AND PROCEDURE=? AND FECPRE=?";
		this.jdbcTemplate.update(query, vimpresiondoc.getTipo(),
				vimpresiondoc.getTer(), vimpresiondoc.getAnio(),
				vimpresiondoc.getNum(), vimpresiondoc.getIdtram(),
				vimpresiondoc.getTipotram(), vimpresiondoc.getProcedure(),
				vimpresiondoc.getFecpre());
		return vimpresiondoc;
	}

	/**
	 * Finds a single row in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc VimpresionDoc
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @return the vimpresion doc
	 */
	@Transactional(readOnly = true)
	public VimpresionDoc find(VimpresionDoc vimpresiondoc) {
		String query = "SELECT t1.TIPO TIPO, t1.TER TER, t1.ANO ANO, t1.NUM NUM, t1.IDTRAM IDTRAM, t1.TIPOTRAM TIPOTRAM, t1.PROCEDURE PROCEDURE, t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC FROM VIMPRESION_DOC t1  WHERE t1.TIPO = ?   AND t1.TER = ?   AND t1.ANO = ?   AND t1.NUM = ?   AND t1.IDTRAM = ?   AND t1.TIPOTRAM = ?   AND t1.PROCEDURE = ?   AND t1.FECPRE = ?  ";

		List<VimpresionDoc> vimpresiondocList = this.jdbcTemplate.query(query,
				this.rwMap, vimpresiondoc.getTipo(), vimpresiondoc.getTer(),
				vimpresiondoc.getAnio(), vimpresiondoc.getNum(),
				vimpresiondoc.getIdtram(), vimpresiondoc.getTipotram(),
				vimpresiondoc.getProcedure(), vimpresiondoc.getFecpre());
		return (VimpresionDoc) DataAccessUtils.uniqueResult(vimpresiondocList);
	}

	/**
	 * Removes a single row in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 */
	public void remove(VimpresionDoc vimpresiondoc) {
		String query = "DELETE FROM VIMPRESION_DOC WHERE TIPO=? AND TER=? AND ANO=? AND NUM=? AND IDTRAM=? AND TIPOTRAM=? AND PROCEDURE=? AND FECPRE=?";
		this.jdbcTemplate.update(query, vimpresiondoc.getTipo(),
				vimpresiondoc.getTer(), vimpresiondoc.getAnio(),
				vimpresiondoc.getNum(), vimpresiondoc.getIdtram(),
				vimpresiondoc.getTipotram(), vimpresiondoc.getProcedure(),
				vimpresiondoc.getFecpre());
	}

	/**
	 * Finds a list of rows in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc jqGridRequestDto JQGridRequestDto List
	 * <VimpresionDoc>
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VimpresionDoc> findAll(VimpresionDoc vimpresiondoc,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TIPO TIPO,t1.TER TER,t1.ANO ANO,t1.NUM NUM,t1.IDTRAM IDTRAM,t1.TIPOTRAM TIPOTRAM,t1.PROCEDURE PROCEDURE,t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC ");
		query.append("FROM VIMPRESION_DOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vimpresiondoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VimpresionDoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VimpresionDoc table using like.
	 * 
	 * vimpresiondoc VimpresionDoc jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<VimpresionDoc>
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VimpresionDoc> findAllLike(VimpresionDoc vimpresiondoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TIPO TIPO,t1.TER TER,t1.ANO ANO,t1.NUM NUM,t1.IDTRAM IDTRAM,t1.TIPOTRAM TIPOTRAM,t1.PROCEDURE PROCEDURE,t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC ");
		query.append("FROM VIMPRESION_DOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vimpresiondoc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VimpresionDoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VimpresionDoc table.
	 * 
	 * vimpresiondoc VimpresionDoc Long
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VimpresionDoc vimpresiondoc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VIMPRESION_DOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vimpresiondoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VimpresionDoc table using like.
	 * 
	 * vimpresiondoc VimpresionDoc startsWith Boolean Long
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VimpresionDoc vimpresiondoc,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VIMPRESION_DOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vimpresiondoc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VimpresionDoc selected for rup_table.
	 * 
	 * vimpresiondoc VimpresionDoc jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<VimpresionDoc>>
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VimpresionDoc>> reorderSelection(
			VimpresionDoc vimpresiondoc, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPO TIPO,t1.TER TER,t1.ANO ANO,t1.NUM NUM,t1.IDTRAM IDTRAM,t1.TIPOTRAM TIPOTRAM,t1.PROCEDURE PROCEDURE,t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC ");
		// FROM
		query.append("FROM VIMPRESION_DOC t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vimpresiondoc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, VimpresionDoc.class, filterParamList,
				"TIPO,TER,ANO,NUM,IDTRAM,TIPOTRAM,PROCEDURE,FECPRE");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VimpresionDoc>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams VimpresionDoc searchParams VimpresionDoc jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<VimpresionDoc>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VimpresionDoc>> search(VimpresionDoc filterParams,
			VimpresionDoc searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPO TIPO,t1.TER TER,t1.ANO ANO,t1.NUM NUM,t1.IDTRAM IDTRAM,t1.TIPOTRAM TIPOTRAM,t1.PROCEDURE PROCEDURE,t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC ");
		// FROM
		query.append("FROM VIMPRESION_DOC t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, VimpresionDoc.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"TIPO,TER,ANO,NUM,IDTRAM,TIPOTRAM,PROCEDURE,FECPRE");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VimpresionDoc>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervimpresiondoc VimpresionDoc jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 *
	 * @param filtervimpresiondoc
	 *            the filtervimpresiondoc
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(VimpresionDoc filtervimpresiondoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPO TIPO,t1.TER TER,t1.ANO ANO,t1.NUM NUM,t1.IDTRAM IDTRAM,t1.TIPOTRAM TIPOTRAM,t1.PROCEDURE PROCEDURE,t1.FECPRE FECPRE, t1.CANALNOTIF CANALNOTIF, t1.OID OID, t1.NOMDOC NOMDOC ");
		// FROM
		query.append("FROM VIMPRESION_DOC t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this
				.getWhereLikeMap(filtervimpresiondoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, VimpresionDoc.class,
						query, params,
						"TIPO,TER,ANO,NUM,IDTRAM,TIPOTRAM,PROCEDURE,FECPRE");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VimpresionDoc entity.
	 * 
	 * vimpresiondoc VimpresionDoc Bean with the criteria values to filter by.
	 * Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VimpresionDoc vimpresiondoc) {

		StringBuilder where = new StringBuilder(
				VimpresionDocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vimpresiondoc != null && vimpresiondoc.getTipo() != null) {
			where.append(" AND t1.TIPO = ?");
			params.add(vimpresiondoc.getTipo());
		}
		if (vimpresiondoc != null && vimpresiondoc.getTer() != null) {
			where.append(" AND t1.TER = ?");
			params.add(vimpresiondoc.getTer());
		}
		if (vimpresiondoc != null && vimpresiondoc.getAnio() != null) {
			where.append(" AND t1.ANO = ?");
			params.add(vimpresiondoc.getAnio());
		}
		if (vimpresiondoc != null && vimpresiondoc.getNumExpDesde() != null) {
			where.append(" AND t1.NUM >= ? ");
			params.add(vimpresiondoc.getNumExpDesde());
		}

		if (vimpresiondoc != null && vimpresiondoc.getNumExpHasta() != null) {
			where.append(" AND t1.NUM <= ?");
			params.add(vimpresiondoc.getNumExpHasta());
		}
		if (vimpresiondoc != null && vimpresiondoc.getIdtram() != null) {
			where.append(" AND t1.IDTRAM = ?");
			params.add(vimpresiondoc.getIdtram());
		}
		if (vimpresiondoc != null && vimpresiondoc.getTipotram() != null) {
			where.append(" AND t1.TIPOTRAM = ?");
			params.add(vimpresiondoc.getTipotram());
		}
		if (vimpresiondoc != null && vimpresiondoc.getProcedure() != null) {
			where.append(" AND t1.PROCEDURE = ?");
			params.add(vimpresiondoc.getProcedure());
		}
		if (vimpresiondoc != null && vimpresiondoc.getFecpreDesde() != null) {
			where.append(" AND t1.FECPRE >= ? ");
			params.add(vimpresiondoc.getFecpreDesde());
		}

		if (vimpresiondoc != null && vimpresiondoc.getFecpreHasta() != null) {
			where.append(" AND t1.FECPRE <= ? ");
			params.add(vimpresiondoc.getFecpreHasta());
		}

		if (vimpresiondoc != null && vimpresiondoc.getCanalNotif() != null) {

			if (0 == vimpresiondoc.getCanalNotif()) {
				where.append(
						" AND ( t1.CANALNOTIF = ? or t1.CANALNOTIF is null) ");
			} else {
				where.append(" AND t1.CANALNOTIF = ? ");
			}
			params.add(vimpresiondoc.getCanalNotif());
		}

		List<String> tipoSel = vimpresiondoc.getTipoSeleccion();
		int i = 0;
		for (String tipo : tipoSel) {
			if (i == 0) {
				where.append(" AND ( ");
			} else {
				where.append(" OR ");
			}
			where.append("t1.TIPO = ? ");
			params.add(tipo);

			i++;
			if (i == tipoSel.size()) {
				where.append(" ) ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VimpresionDoc entity.
	 * 
	 * vimpresiondoc VimpresionDoc Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param vimpresiondoc
	 *            the vimpresiondoc
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VimpresionDoc vimpresiondoc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VimpresionDocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vimpresiondoc != null && vimpresiondoc.getTipo() != null) {
			where.append(" AND UPPER(t1.TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vimpresiondoc.getTipo().toUpperCase() + "%");
			} else {
				params.add("%" + vimpresiondoc.getTipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO IS NOT NULL");
		}
		if (vimpresiondoc != null && vimpresiondoc.getTer() != null) {
			where.append(" AND UPPER(t1.TER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vimpresiondoc.getTer().toUpperCase() + "%");
			} else {
				params.add("%" + vimpresiondoc.getTer().toUpperCase() + "%");
			}
			where.append(" AND t1.TER IS NOT NULL");
		}
		if (vimpresiondoc != null && vimpresiondoc.getAnio() != null) {
			where.append(" AND UPPER(t1.ANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vimpresiondoc.getAnio().toUpperCase() + "%");
			} else {
				params.add("%" + vimpresiondoc.getAnio().toUpperCase() + "%");
			}
			where.append(" AND t1.ANO IS NOT NULL");
		}
		if (vimpresiondoc != null && vimpresiondoc.getNumExpDesde() != null) {
			where.append(" AND t1.NUM >= ? ");
			params.add(vimpresiondoc.getNumExpDesde());
		}

		if (vimpresiondoc != null && vimpresiondoc.getNumExpHasta() != null) {
			where.append(" AND t1.NUM <= ?");
			params.add(vimpresiondoc.getNumExpHasta());
		}
		if (vimpresiondoc != null && vimpresiondoc.getIdtram() != null) {
			where.append(" AND t1.IDTRAM = ?");
			params.add(vimpresiondoc.getIdtram());
		}
		if (vimpresiondoc != null && vimpresiondoc.getTipotram() != null) {
			where.append(" AND t1.TIPOTRAM = ?");
			params.add(vimpresiondoc.getTipotram());
		}
		if (vimpresiondoc != null && vimpresiondoc.getProcedure() != null) {
			where.append(" AND UPPER(t1.PROCEDURE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vimpresiondoc.getProcedure().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vimpresiondoc.getProcedure().toUpperCase() + "%");
			}
			where.append(" AND t1.PROCEDURE IS NOT NULL");
		}
		if (vimpresiondoc != null && vimpresiondoc.getFecpreDesde() != null) {
			where.append(" AND t1.FECPRE >= ? ");
			params.add(vimpresiondoc.getFecpreDesde());
		}

		if (vimpresiondoc != null && vimpresiondoc.getFecpreHasta() != null) {
			where.append(" AND t1.FECPRE <= ?");
			params.add(vimpresiondoc.getFecpreHasta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
